/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobBlacksmith;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingBlacksmith
extends AbstractBuildingWorker
implements IBuildingPublicCrafter {
    private static final String BLACKSMITH = "blacksmith";

    public BuildingBlacksmith(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BLACKSMITH;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobBlacksmith(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return BLACKSMITH;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Strength;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Focus;
    }

    @Override
    @NotNull
    public Skill getCraftSpeedSkill() {
        return this.getPrimarySkill();
    }

    @Override
    @NotNull
    public Skill getRecipeImprovementSkill() {
        return this.getSecondarySkill();
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.blacksmith;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            return this.getMainBuildingJob().orElseGet(() -> new JobBlacksmith(null));
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            boolean matchOverride;
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            ItemStack output = recipe.getPrimaryOutput();
            boolean bl = matchOverride = output.func_77973_b() instanceof ToolItem || output.func_77973_b() instanceof SwordItem || output.func_77973_b() instanceof ArmorItem || output.func_77973_b() instanceof HoeItem || output.func_77973_b() instanceof ShieldItem || Compatibility.isTinkersWeapon(output);
            if (matchOverride) {
                return true;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingBlacksmith.BLACKSMITH).orElse(false);
        }
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingBlacksmith.BLACKSMITH);
        }
    }
}

